#include "PluginEditor.h"
#include "PluginProcessor.h"
#include <juce_audio_processors/juce_audio_processors.h>

//#include "../include/vendor/reaper-sdk/sdk/reaper_plugin_functions.h"

//==============================================================================
AudioPluginAudioProcessorEditor::AudioPluginAudioProcessorEditor(AudioPluginAudioProcessor& p)
    : AudioProcessorEditor(&p)
    , processorRef(p)
{
    juce::ignoreUnused(processorRef);
    // Make sure that before the constructor has finished, you've set the
    // editor's size to whatever you need it to be.
    if (processorRef.getEmbedEditor()) {
        setSize(80, 90);
        midiVolume.setSliderStyle (juce::Slider::LinearBarVertical);
        midiVolume.setRange (0.0, 127.0, 1.0);
        midiVolume.setTextBoxStyle (juce::Slider::NoTextBox, false, 90, 0);
        midiVolume.setPopupDisplayEnabled (false, false, this);
        addAndMakeVisible(&midiVolume);
        processorRef.setMidiVolume_embed(&midiVolume);
        midiVolume.addListener(this);
        midiVolume.setValue(processorRef.getCurrentParameter()->midiVolume);
        embedText.setSize(60, 20);
        auto font = embedText.getFont();
        font.setHeight(12);
        embedText.setFont(font);
        embedText.setTopLeftPosition({21, 20});
        addAndMakeVisible (&embedText);
     } else {
        setSize(400, 300);
        midiVolume.setSliderStyle (juce::Slider::LinearBarVertical);
        midiVolume.setRange (0.0, 127.0, 1.0);
        midiVolume.setTextBoxStyle (juce::Slider::NoTextBox, false, 90, 0);
        midiVolume.setPopupDisplayEnabled (true, false, this);
        midiVolume.setTextValueSuffix (" Volume");
        addAndMakeVisible (&midiVolume);
        processorRef.setMidiVolume_main(&midiVolume);
        midiVolume.addListener(this);
        midiVolume.setValue(processorRef.getCurrentParameter()->midiVolume);
//        juce::String s = juce::String::formatted("GUI embedding Demo\nMidi Volume =  %d", processorRef.getMidiVolumeCurrent());
//        mainText.setText(s, juce::dontSendNotification);
        mainText.setSize(400, 70);
        auto font = mainText.getFont();
        font.setHeight(30);
        mainText.setFont(font);
        mainText.setTopLeftPosition({100, 20});
        addAndMakeVisible (&mainText);
            juce::String vstvers;
    }
}

AudioPluginAudioProcessorEditor::~AudioPluginAudioProcessorEditor() {
    processorRef.setMidiVolume_main(NULL);
 }

//==============================================================================
void AudioPluginAudioProcessorEditor::paint(juce::Graphics& g)
{
    if (processorRef.getEmbedEditor()) {
      // (Our component is opaque, so we must completely fill the background with a
      // solid colour)
      g.fillAll(
          getLookAndFeel().findColour(juce::ResizableWindow::backgroundColourId));
//          juce::Colour(0xff, 0, 0));

      g.setColour(juce::Colours::white);
      g.setFont(15.0f);
      juce::Rectangle<int> r = getLocalBounds();
      r.setHeight(20);
      g.drawFittedText("secondaryGUI", r,
          juce::Justification::centred, 1);
     } else {     
      // (Our component is opaque, so we must completely fill the background with a
      // solid colour)
      g.fillAll(
          getLookAndFeel().findColour(juce::ResizableWindow::backgroundColourId));
      juce::String vstvers;    
        switch (processorRef.wrapperType ) {
          case 1:                                                        // AudioProcessor::wrapperType_VST: todo: use correct name
            vstvers = "VST2";
            g.setColour(juce::Colour(0x00,0xFF, 0x00));
          break;  
          case 2:                                                        // AudioProcessor::wrapperType_VST3: todo: use correct name
            vstvers = "VST3";
            g.setColour(juce::Colour(0x00,0xFF, 0x00));
          break;  
          default: 
            vstvers = "plugin type not supported";
            g.setColour(juce::Colour(0xFF,0x00, 0x00));
          break;  
        }
      g.drawFittedText (vstvers, getLocalBounds(), juce::Justification::centred, 1);




    }      
}

void AudioPluginAudioProcessorEditor::resized()
{
    // This is generally where you'll want to lay out the positions of any
    // subcomponents in your editor..
    if (processorRef.getEmbedEditor()) {
//      midiVolume.setBounds (getWidth() / 2, 45, 20, getHeight() - 50);
      midiVolume.setBounds (5, 30, 20, getHeight() - 35);

    } else {
      midiVolume.setBounds (40, 30, 20, getHeight() - 60);
   }
}

void AudioPluginAudioProcessorEditor::sliderValueChanged (juce::Slider* sliderThatWasMoved)
{
    processorRef.setEmbeddedUpdated(true);
    auto MidiVolume_embed = processorRef.getMidiVolume_embed();
    auto MidiVolume_main  = processorRef.getMidiVolume_main();
    double v;
    auto cp=processorRef.getCurrentParameter();
    if (sliderThatWasMoved) {
        if (sliderThatWasMoved == MidiVolume_main) {
            v = MidiVolume_main->getValue();
            if (cp->midiVolume != v){
                cp->midiVolume = v;
                cp->changeOrigin = co_main;
                MidiVolume_embed->setValue(v);
/*                                                     
  Warning: 
  ========
  Is it really always allowed to use AudioParameterFloat in the GUI thread ? 
*/  
                *(processorRef.getParamMidiVolume()) = v;
            }    
          } else if (sliderThatWasMoved == MidiVolume_embed) {
            v = MidiVolume_embed->getValue();
            if (cp->midiVolume != v){
                cp->midiVolume = v;
                cp->changeOrigin = co_embed;
                MidiVolume_main->setValue(v);            
/*                                                     
  Warning: 
  ========
  Is it really always allowed to use AudioParameterFloat in the GUI thread ? 
*/  
                *(processorRef.getParamMidiVolume()) = v;
            }    
        }
    }
    valueChanged();
}

void AudioPluginAudioProcessorEditor::valueChanged () {
    auto MidiVolume_embed = processorRef.getMidiVolume_embed();
    auto MidiVolume_main  = processorRef.getMidiVolume_main();
//    double v;
    if (MidiVolume_main) {                                      // the Text also is allocated
        juce::String s = juce::String::formatted("GUI embedding Demo\nMidi Volume =  %d", int(processorRef.getCurrentParameter()->midiVolume+0.5));
        mainText.setText(s, juce::dontSendNotification);
    }   
    if (MidiVolume_embed) {                                      // the Text also is allocated
        juce::String s;
        switch(processorRef.getCurrentParameter()->changeOrigin){
          case co_default:
            s = "Default";
          case co_main:
            s = "Main GUI";
          break;    
          case co_embed:
            s = "embed GUI";
          break;    
          case co_dawparam:
            s = "DAW Param";
          break;    
          case co_midi:
            s = "Midi CC";
          break;            
          case co_file:
            s = "ProjectFile";
          break;            
          default: 
            s = "????";
          break;    
        }
        embedText.setText(s, juce::dontSendNotification);
    }   
    processorRef.dawNotify();
}
