#include "PluginProcessor.h"
#include "PluginEditor.h"
#include "juce_core/system/juce_PlatformDefs.h"
#include <cstddef>
#include <pluginterfaces/base/funknown.h>

//#define VSTSDK24_INSTALLED
#ifdef VSTSDK24_INSTALLED
   #include "pluginterfaces/vst2.x/aeffect.h"
   #define effEditDraw_ DECLARE_VST_DEPRECATED (effEditDraw)
  #else
   #define DECLARE_VST_DEPRECATED(identifier) __##identifier##Deprecated
   #define effEditDraw_ 16                                                  // correct but irrelevant, as VST2 is not compilable
#endif  

//#include "juce_audio_processors/processors/juce_AudioProcessor.h"
//#include <juce_audio_processors/utilities/juce_VSTCallbackHandler.h>




#define REAPERAPI_IMPLEMENT
//#define REAPERAPI_MINIMAL    /* if ndef implement all API functions */
//#define REAPERAPI_WANT_ShowConsoleMsg

#include "../include/vendor/reaper-sdk/sdk/reaper_plugin_functions.h"
// Provides macro definitions for things like "REAPER_FXEMBED_WM_GETMINMAXINFO"
#include "../include/vendor/reaper-sdk/sdk/reaper_plugin_fx_embed.h"

// Provider IReaperHostApplication, IReaperUIEmbedInterface properly wrapped
namespace reaper {
    //==============================================================================
    /* 
        Definimng the Reaper Interfaces for VST3 
     */
    DEF_CLASS_IID (IReaperHostApplication)
    DEF_CLASS_IID (IReaperUIEmbedInterface)
}

void AudioPluginAudioProcessor::audioProcessorParameterChanged(AudioProcessor* processor,
                                                 int parameterIndex,
                                                 float newValue){
/*                                                     
  Warning: 
  ========
  AFAIK, it is not garanteed, that the host calls this function in the GUI context. 
  hence when calling nin thread safe functions we should use e.g. AsyncUpdater and AbstractFIFO 
  to notify the other Thread and transfer data, or simply save the data somewher and use puire GUI 
  means to make sure that they are acknowlaged by the GUI thread.
  According to JUCE, setValue(e.g. for a slider) is thread save, so no problem here. 
  But calling Reaper API functions definitively is not thread save.
*/  
    double v = *midiVolumeParameter;
    v = floor(v+0.5);
    if (currentParameter.midiVolume != v) {
        currentParameter.changeOrigin = co_dawparam;
        currentParameter.midiVolume = v;
        if (midiVolume_main) {
            midiVolume_main->setValue(v);
        }    
        if (midiVolume_embed) {
            midiVolume_embed->setValue(v);
        }    
        embedded_updated = true;
    }   
    juce::ignoreUnused(processor, parameterIndex, newValue);
 
}

void AudioPluginAudioProcessor::audioProcessorChanged (juce::AudioProcessor* processor, const juce::AudioProcessorListener::ChangeDetails& details) {
    juce::ignoreUnused(processor, details);
}


//==============================================================================
AudioPluginAudioProcessor::AudioPluginAudioProcessor()
    : AudioProcessor(
        BusesProperties()
#if !JucePlugin_IsMidiEffect
#if !JucePlugin_IsSynth
            .withInput("Input", juce::AudioChannelSet::stereo(), true)
#endif
            .withOutput("Output", juce::AudioChannelSet::stereo(), true)
#endif
    )
{
    embedEditor = true;
    embedComponent = reaperCreateEmbedEditor();
    endEembedEditor();

    AudioProcessor::addParameter (midiVolumeParameter = new juce::AudioParameterFloat ("midivolume", // parameterID
                                                            "MidiVolume", // parameter name
                                                            0.0f,   // minimum value
                                                            127.0f,   // maximum value
                                                            1.0f)); // default value
    AudioProcessor::addListener(this);
}

    /*
       * cant be a class variable, as getfuncaddr() can't be a class function
       * hence definied static
    */
    reaper::IReaperHostApplication *reaperApplicationPtr = NULL;
    AudioPluginAudioProcessor *audioPluginAudioProcessor;
    void *getfuncaddr(const char* funcname)
	{
        if (reaperApplicationPtr) {                                      // VST3   
          return static_cast<void (*)(const char* msg)>(reaperApplicationPtr->getReaperApi(funcname));
        } 
        void *res = audioPluginAudioProcessor->getfuncaddr_(funcname);
        if (res) {                                                       // VST2
           return res;
        }
      return NULL;                                                       // crash   
	};

AudioPluginAudioProcessor::~AudioPluginAudioProcessor() { 
}

static int callcounter = 0;                                // common for all instances !



void showHostContext() {
    callcounter++;
    juce::String s = juce::String::formatted(" --- instance count %d ---\n", callcounter);
    ShowConsoleMsg(s.toRawUTF8());
}

void AudioPluginAudioProcessor::timerCallback()
{
//    DBG("Timer callback invoked");
    if (!embedComponent) {
      embedEditor = false;  
      return;
    }  
	embedComponent->setVisible(false);
	embedComponent->removeFromDesktop();
	embedComponent->setAlwaysOnTop(false);   
    canEndEmbedEditor = true; 
    endEembedEditor();
    stopTimer();
}

    Steinberg::TPtrInt AudioPluginAudioProcessor::handledEmbeddedUIMessage (int msg,
                                                 Steinberg::TPtrInt parm2,
                                                 Steinberg::TPtrInt parm3)  {
    if (!embedComponent)
        return 0;
    return reaperHandleEmbedGUI((void*)parm2, (void*)parm3, msg);
}


//==============================================================================

const juce::String AudioPluginAudioProcessor::getName() const
{
    return JucePlugin_Name;
}

bool AudioPluginAudioProcessor::acceptsMidi() const
{
#if JucePlugin_WantsMidiInput
    return true;
#else
    return false;
#endif
}

bool AudioPluginAudioProcessor::producesMidi() const
{
#if JucePlugin_ProducesMidiOutput
    return true;
#else
    return false;
#endif
}

bool AudioPluginAudioProcessor::isMidiEffect() const
{
#if JucePlugin_IsMidiEffect
    return true;
#else
    return false;
#endif
}

double AudioPluginAudioProcessor::getTailLengthSeconds() const { return 0.0; }

int AudioPluginAudioProcessor::getNumPrograms()
{
    return 1; // NB: some hosts don't cope very well if you tell them there are 0
        // programs, so this should be at least 1, even if you're not really
        // implementing programs.
}

int AudioPluginAudioProcessor::getCurrentProgram() { return 0; }

void AudioPluginAudioProcessor::setCurrentProgram(int index)
{
    juce::ignoreUnused(index);
}

const juce::String AudioPluginAudioProcessor::getProgramName(int index)
{
    juce::ignoreUnused(index);
    return {};
}

void AudioPluginAudioProcessor::changeProgramName(int index,
    const juce::String& newName)
{
    juce::ignoreUnused(index, newName);
}

//==============================================================================
void AudioPluginAudioProcessor::prepareToPlay(double sampleRate,
    int samplesPerBlock)
{
    // Use this method as the place to do any pre-playback
    // initialisation that you need..
    juce::ignoreUnused(sampleRate, samplesPerBlock);
}

void AudioPluginAudioProcessor::releaseResources()
{
    // When playback stops, you can use this as an opportunity to free up any
    // spare memory, etc.    
}

bool AudioPluginAudioProcessor::isBusesLayoutSupported(
    const BusesLayout& layouts) const
{
#if JucePlugin_IsMidiEffect
    juce::ignoreUnused(layouts);
    return true;
#else
    // This is the place where you check if the layout is supported.
    // In this template code we only support mono or stereo.
    // Some plugin hosts, such as certain GarageBand versions, will only
    // load plugins that support stereo bus layouts.
    if (layouts.getMainOutputChannelSet() != juce::AudioChannelSet::mono() && layouts.getMainOutputChannelSet() != juce::AudioChannelSet::stereo())
        return false;

        // This checks if the input layout matches the output layout
#if !JucePlugin_IsSynth
    if (layouts.getMainOutputChannelSet() != layouts.getMainInputChannelSet())
        return false;
#endif

    return true;
#endif
}

void AudioPluginAudioProcessor::processBlock(juce::AudioBuffer<float>& buffer,
    juce::MidiBuffer& midiMessages)
{
    juce::ignoreUnused(midiMessages);

    juce::ScopedNoDenormals noDenormals;
    auto totalNumInputChannels = getTotalNumInputChannels();
    auto totalNumOutputChannels = getTotalNumOutputChannels();

    // In case we have more outputs than inputs, this code clears any output
    // channels that didn't contain input data, (because these aren't
    // guaranteed to be empty - they may contain garbage).
    // This is here to avoid people getting screaming feedback
    // when they first compile a plugin, but obviously you don't need to keep
    // this code if your algorithm always overwrites all the output channels.
    for (auto i = totalNumInputChannels; i < totalNumOutputChannels; ++i)
        buffer.clear(i, 0, buffer.getNumSamples());

    // This is the place where you'd normally do the guts of your plugin's
    // audio processing...
    // Make sure to reset the state if your inner loop is processing
    // the samples and the outer loop is handling the channels.1
    // Alternatively, you can process the samples with the channels
    // interleaved by keeping the same state.
    for (int channel = 0; channel < totalNumInputChannels; ++channel) {
        auto* channelData = buffer.getWritePointer(channel);
        juce::ignoreUnused(channelData);
        // ..do something to the data...
    }

    const int midiChannel = 1;
    const int controllertype = 1;
    juce::MidiBuffer newMidiMessages{};
    for (const auto meta : midiMessages) {
        auto msg = meta.getMessage();
        if (msg.isForChannel (midiChannel)) {
            if (msg.isControllerOfType(controllertype)) {
                MidiValue v;
                v.val =  msg.getControllerValue();
                midiInFiFo.addToFifo(&v, 1);
                triggerAsyncUpdate();
            }
        }
    }
    midiMessages.clear();
    const int CCmsg = 0xB0 + midiChannel; // + 1;
    int size;
    MidiValue mv;
    while ((size = midiOutFiFo.readFromFifo(&mv, 1))>0) {
        juce::MidiMessage msg{CCmsg, controllertype, mv.val};
        midiMessages.addEvent(msg, 0);
    }   
}

//==============================================================================
bool AudioPluginAudioProcessor::hasEditor() const
{
    return true; // (change this to false if you choose to not supply an editor)
}

juce::AudioProcessorEditor* AudioPluginAudioProcessor::createEditor()
{
//    DBG("[AudioPluginAudioProcessor::createEditor] embedEditor = " << (int)embedEditor << " midiVolume_embed = " << (int)midiVolume_embed << " midiVolume_main = " << (int)midiVolume_main);
    embedded_updated = true;
    return new AudioPluginAudioProcessorEditor(*this);
}

//==============================================================================
void AudioPluginAudioProcessor::getStateInformation(
    juce::MemoryBlock& destData)
{
    // You should use this method to store your parameters in the memory block.
    // You could do that either as raw data, or use the XML or ValueTree classes
    // as intermediaries to make it easy to save and load complex data.
    destData.setSize(sizeof(currentParameter));
    *((CurrentParameter*)destData.getData()) = currentParameter;
}

void AudioPluginAudioProcessor::setStateInformation(const void* data,
    int sizeInBytes)
{
    // You should use this method to restore your parameters from this memory
    // block, whose contents will have been created by the getStateInformation()
    // call.
    if (sizeInBytes == sizeof(currentParameter)) {
      currentParameter = *((CurrentParameter*) data);
      currentParameter.changeOrigin = co_file;
      double v = currentParameter.midiVolume;
      if (midiVolume_main) {
        midiVolume_main->setValue(v);
      }    
      if (midiVolume_embed) {
          midiVolume_embed->setValue(v);
      }      
      embedded_updated = true;
    }  
}

//==============================================================================
// This creates new instances of the plugin..
juce::AudioProcessor* JUCE_CALLTYPE createPluginFilter()
{
    return new AudioPluginAudioProcessor();
}

reaper::INT_PTR  AudioPluginAudioProcessor::reaperHandleEmbedGUI(void* value, void* ptr, int opt){
    bool modeChange = false;;
    embedEditor = true;

    switch (opt) {
        /* return 1 if embedding is supported and available
		* return -1 if embedding is supported and unavailable
		* return 0 if embedding is not supported
		*/
    case REAPER_FXEMBED_WM_IS_SUPPORTED:
        endEembedEditor();
        return 1;

    // called when embedding begins (return value ignored)
    case REAPER_FXEMBED_WM_CREATE: 
        endEembedEditor();
        return 0;

    // called when embedding ends (return value ignored)
    case REAPER_FXEMBED_WM_DESTROY: 
        endEembedEditor();
        return 0;

        /*
		* get size hints. ptr = (REAPER_FXEMBED_SizeHints*). return 1 if supported
		* note that these are just hints, the actual size may vary
		*/
    case REAPER_FXEMBED_WM_GETMINMAXINFO:
        if (ptr) {
            auto mmi = (reaper::REAPER_FXEMBED_SizeHints*)ptr;
            mmi->min_width = 80;
            mmi->min_height = 90;
            mmi->max_width = 100;
            mmi->max_height = 110;
            mmi->preferred_aspect = 0;
            mmi->minimum_aspect = 0;
        }
        endEembedEditor();
        return 1;

    // [NOTE]: Not really sure what this does (Gavin)
    // parm3: REAPER_FXEMBED_DrawInfo*. set mouse cursor and return REAPER_FXEMBED_RETNOTIFY_HANDLED, or return 0.
    case REAPER_FXEMBED_WM_SETCURSOR:
        if (ptr) {
            endEembedEditor();
            return REAPER_FXEMBED_RETNOTIFY_HANDLED;
        }
        endEembedEditor();
        return 0;

    /*
		* mouse messages
		* ptr = (REAPER_FXEMBED_DrawInfo*)
		* capture is automatically set on mouse down, released on mouse up
		* when not captured, will always receive a mousemove when exiting the window
		*
		* if the mouse messages return with REAPER_FXEMBED_RETNOTIFY_INVALIDATE set, a non-optional
		* redraw is initiated (generally sooner than the next timer-based redraw)
		*/
    case REAPER_FXEMBED_WM_MOUSEMOVE:
    case REAPER_FXEMBED_WM_LBUTTONDOWN:
    case REAPER_FXEMBED_WM_LBUTTONUP:
    case REAPER_FXEMBED_WM_LBUTTONDBLCLK:
    case REAPER_FXEMBED_WM_RBUTTONDOWN:
    case REAPER_FXEMBED_WM_RBUTTONUP:
    case REAPER_FXEMBED_WM_RBUTTONDBLCLK:
    case REAPER_FXEMBED_WM_MOUSEWHEEL:
        if (!embedComponent) {
            endEembedEditor();
            return 0;
        }   
        if (ptr) {
          //inf->context =  1=TCP, 2=MCP
            auto draw_info = (reaper::REAPER_FXEMBED_DrawInfo*)ptr;
            if (draw_info) {        
                if (infContetext != draw_info->context) {
                    infContetext = draw_info->context;
                    modeChange = true;
                }    
            }
            auto point = juce::Point<float>(draw_info->mouse_x, draw_info->mouse_y);

            juce::Desktop& desktop = juce::Desktop::getInstance();
            auto mms = desktop.getMainMouseSource();

            // using mouseEventParams = struct {
            // 	   juce::MouseInputSource source;
            //     juce::Point<float> position;
            //     juce::ModifierKeys modifiers;
            //     float pressure, orientation,  rotation, tiltX, tiltY;
            //     juce::Component* eventComponent, originator;
            //     juce::Time eventTime;
            //     juce::Point<float> mouseDownPos;
            //     juce::Time mouseDownTime;
            //     int numberOfClicks;
            //     bool mouseWasDragged;
            // };

            // auto it = mouseEventParams{
            // 	.source = mms,
            // 	.position = point,
            // };

            auto ev = juce::MouseEvent(mms, point, 0, 0,
                0, 0, 0, 0,
                embedComponent, embedComponent,
                juce::Time(0),
                point, juce::Time(0),
                1, false);

            int w = draw_info->width, h = draw_info->height;
            if (draw_info->mouse_x < 0 || draw_info->mouse_y < 0) {
                endEembedEditor();
                return 1;
            }    

            juce::Point<float> ptDesktop = mms.getScreenPosition();
            // calculate desktop position of BMP
            juce::Point<float> mousePosDesktop = mms.getScreenPosition();
            juce::Point<float> mousePosBmp = juce::Point<float>(draw_info->mouse_x, draw_info->mouse_y);
            // posBmp = mousePosDesktop-mousePosBmp
            juce::Point<float> posBmp = mousePosDesktop - mousePosBmp;
            juce::Point<int> posBmpInt;
            //	posBmpInt.x = (int)posBmp.x;
            //  posBmpInt.y = (int)posBmp.y;
            //	posBmpInt.x = (int)0;
            //	posBmpInt.y = (int)0;

            int rim = 10;
            int lowerBorder_x = rim;
            int upperBorder_x = w - rim;
            int lowerBorder_y = rim;
            int upperBorder_y = h - rim;
            if ((lowerBorder_x < point.x && point.x < upperBorder_x) && (lowerBorder_y < point.y && point.y < upperBorder_y)) {
                juce::Rectangle<int> rect = { (int)posBmp.x, (int)posBmp.y, w, h };
                //				embedComponent->setTopLeftPosition(posBmpInt);
                embedComponent->setBounds(rect);
                embedComponent->setVisible(true);
                embedComponent->addToDesktop(0);
                embedComponent->setAlwaysOnTop(true);
                canEndEmbedEditor = false;
                Timer::startTimer(500);                       // hide overlay GUI, show bitmap again. 
            } else {
                embedComponent->setVisible(false);
                embedComponent->removeFromDesktop();
                embedComponent->setAlwaysOnTop(false);
            }
        }
        return 1;

    /* draw embedded UI.
	* 
	* parm2: REAPER_FXEMBED_IBitmap * to draw into. note
	* parm3: REAPER_FXEMBED_DrawInfo *
	*
	* if flags has REAPER_FXEMBED_DRAWINFO_FLAG_PAINT_OPTIONAL set, update is optional. if no change since last draw, return 0.
	* if flags has REAPER_FXEMBED_DRAWINFO_FLAG_LBUTTON_CAPTURED set, left mouse button is down and captured
	* if flags has REAPER_FXEMBED_DRAWINFO_FLAG_RBUTTON_CAPTURED set, right mouse button is down and captured
	*
	* HiDPI:
	* if REAPER_FXEMBED_IBitmap::Extended(REAPER_FXEMBED_EXT_GET_ADVISORY_SCALING,NULL) returns nonzero, then it is a 24.8 scalefactor for UI drawing
	*
    * return 1 if drawing occurred, 0 otherwise.
	*/
    case REAPER_FXEMBED_WM_PAINT:
        if(!embedComponent) {
            embedEditor=false;
            return 0;
        }    
        auto draw_info = (reaper::REAPER_FXEMBED_DrawInfo*)ptr;
        if (draw_info) {        
            if (infContetext != draw_info->context) {
                infContetext = draw_info->context;
                modeChange = true;
            }    
        }    
        if (value && ptr) {
            if (modeChange) {
                // need to update 
                embedded_updated = true;
            }
            int inf_flags = (int)(reaper::INT_PTR)draw_info->flags;
            if (inf_flags & 1)  {                              // does Reaper force displaying 
            	if (!embedded_updated){                        // did we modify the picture 
                    endEembedEditor();
            		return 0;
                }  
              } else {    
                embedEditor = true;                            // e.g. start displaying embedded GU
            }      
            if (!juceStartDelay) {                             // as long as the Juce logo is displayed, keep updating the bmp
                embedded_updated = false;
              } else {
                juceStartDelay--;                              // fake timer 
            }
            ((AudioPluginAudioProcessorEditor*) embedComponent)->valueChanged();
            reaper::REAPER_FXEMBED_IBitmap* bmp = (reaper::REAPER_FXEMBED_IBitmap*)value;
            int w = bmp->getWidth();
            int h = bmp->getHeight();
            // bmp->resize(80, 90);

            //copy img->bmp;
            juce::Image img(juce::Image::PixelFormat::ARGB,
                w, h, true);
            juce::Graphics g(img);
//            juce::Rectangle<int> r { (int)posBmp.x, (int)posBmp.y, w, h };
            juce::Rectangle<int> r { embedComponent->getBounds() };
            r.setWidth(w);
            r.setHeight(h);
            embedComponent->setBounds(r);
            embedComponent->paintEntireComponent(g, false);
            int reaperBmpRowSpan = bmp->getRowSpan();
            unsigned int* reaperBmpBits = bmp->getBits();
            juce::Image::BitmapData juceBmpData ( img, juce::Image::BitmapData::readOnly );

            int ls = juceBmpData.lineStride;
            if (ls != (reaperBmpRowSpan * sizeof(unsigned int))) {
                juce::uint8* lineStartPtr;
                w *= sizeof(unsigned int);
                for (int y = 0; y < h; y++) {
                    lineStartPtr = juceBmpData.getLinePointer(y);
                    for (int x = 0; x < w; x++) {
                        memcpy(reaperBmpBits, lineStartPtr, w);
//                        memset(reaperBmpBits, 0xAA, w);
                    }
                    reaperBmpBits += reaperBmpRowSpan;
                }
            } else {
                juce::uint8* lineStartPtr;
                lineStartPtr = juceBmpData.getLinePointer(0);
                memcpy(reaperBmpBits, lineStartPtr, ls * h);
            }
            endEembedEditor();
            return 1;
        }
        endEembedEditor();
        return 0;
    }
    endEembedEditor();
    return 0;
}

juce::AudioProcessorEditor* AudioPluginAudioProcessor::reaperCreateEmbedEditor(){
//    DBG("[AudioPluginAudioProcessor::reaperCreateEmbedEditor] embedEditor = " << (int)embedEditor << " midiVolume_embed = " << (int)midiVolume_embed << " midiVolume_main = " << (int)midiVolume_main);
    embedded_updated = true;
    embedEditor = true;
    auto* editComponent = this->createEditor();
    endEembedEditor();
    return editComponent;
};

void AudioPluginAudioProcessor::endEembedEditor() 
{
   if (canEndEmbedEditor) {
       embedEditor = false; 
//       canEndEmbedEditor = false;
   }   
}

bool AudioPluginAudioProcessor::getEmbedEditor() 
{
    return embedEditor;
};



void AudioPluginAudioProcessor::setEmbeddedUpdated(bool v)
{
  embedded_updated = v;
}

juce::Slider *AudioPluginAudioProcessor::getMidiVolume_embed(){
    return midiVolume_embed;
};

void AudioPluginAudioProcessor::setMidiVolume_embed(juce::Slider *v){
//    DBG("[AudioPluginAudioProcessor::setMidiVolume_embed] midiVolume_embed = " << (int)v);    
    midiVolume_embed = v;
};  

juce::Slider *AudioPluginAudioProcessor::getMidiVolume_main(){
    return midiVolume_main;
};

void AudioPluginAudioProcessor::setMidiVolume_main(juce::Slider *v){
//    DBG("[AudioPluginAudioProcessor::setMidiVolume_main] midiVolume_main = " << (int)v);    
    midiVolume_main = v;
};  

juce::AudioParameterFloat* AudioPluginAudioProcessor::getParamMidiVolume(){
    return midiVolumeParameter;
}

CurrentParameter *AudioPluginAudioProcessor::getCurrentParameter(){
    return &currentParameter;
}

void AudioPluginAudioProcessor::dawNotify() {
    auto v = currentParameter.midiVolume;
    int iv = int(v+0.5);
    MidiValue mv;
    if (dawLastChange != iv) {
        dawLastChange = iv;
        mv.val = iv;
        midiOutFiFo.addToFifo(&mv, 1);
        juce::String s = juce::String::formatted("Parameter changed to %d ---\n", iv);
        ShowConsoleMsg(s.toRawUTF8());
    }    
}    

void  AudioPluginAudioProcessor::handleAsyncUpdate() {
    MidiValue mv;
    int size;
    while ((size = midiInFiFo.readFromFifo(&mv,1))>0) {
        if (midiLastChange != mv.val) {
            midiLastChange = mv.val;
            juce::String s = juce::String::formatted("Midi Message: %d ---\n", mv.val);
            ShowConsoleMsg(s.toRawUTF8());
        } 
        if (currentParameter.midiVolume != mv.val) {
            currentParameter.changeOrigin = co_midi;
            currentParameter.midiVolume = mv.val;
            *midiVolumeParameter = mv.val;
            if (midiVolume_main) {
                midiVolume_main->setValue(mv.val);
            }    
            if (midiVolume_embed) {
                midiVolume_embed->setValue(mv.val);
            }    
            embedded_updated = true;
        }    
    }
}


juce::pointer_sized_int AudioPluginAudioProcessor::handleVstManufacturerSpecific (juce::int32 index,
                                                     juce::pointer_sized_int value,
                                                     void* ptr,
                                                     float opt) {
    switch  ((enum AEffectOpcodes)index) {
      case effEditDraw_:    
//            DBG("[AudioPluginAudioProcessor::handleReaperEmbedMessage] index = " << index << " value = " << value << " ptr = " << ptr << " opt = " << opt);
        if (!embedComponent) return 0;
        return reaperHandleEmbedGUI((void *)value, ptr, (int)opt);
    }
    return 0;                                                     
}



void AudioPluginAudioProcessor::setIHostApplication (Steinberg::FUnknown* ptr) {
    audioPluginAudioProcessor = this;
    if (ptr == nullptr)
        return;
    void* objPtr = nullptr;

    if (ptr->queryInterface (reaper::IReaperHostApplication::iid, &objPtr) == Steinberg::kResultOk)        {
        reaperApplicationPtr = static_cast<reaper::IReaperHostApplication*> (objPtr);
        int errcnt = REAPERAPI_LoadAPI(getfuncaddr);
        juce::ignoreUnused(errcnt);
        showHostContext();
    }
}

int32_t AudioPluginAudioProcessor::queryIEditController (const Steinberg::TUID tuid, void** obj) {
    if (std::memcmp (tuid, embeddedUi.iid, sizeof (Steinberg::TUID)) == 0)
    {
        *obj = &embeddedUi;
        return Steinberg::kResultOk;
    }

    *obj = nullptr;
    return Steinberg::kNoInterface;
}


    void AudioPluginAudioProcessor::handleVstHostCallbackAvailable (std::function<VstHostCallbackType>&& callback) {
        hostcb = callback;
        audioPluginAudioProcessor = this;
        int errcnt = REAPERAPI_LoadAPI(getfuncaddr);
        juce::ignoreUnused(errcnt);
        showHostContext();
        void (*AddExtensionsMainMenu)();
        *(juce::pointer_sized_int *)&AddExtensionsMainMenu = hostcb(/*NULL,*/0xdeadbeef,0xdeadf00d,0,"AddExtensionsMainMenu",0.0);
    }

    juce::pointer_sized_int AudioPluginAudioProcessor::handleVstPluginCanDo (juce::int32 index,
                                                      juce::pointer_sized_int value,
                                                      void* ptr,
                                                      float opt) {
        juce::ignoreUnused (index, value, opt);

        auto matches =  [ptr] (const char* s) -> bool { return strcmp ((char*)ptr, s) == 0; };

        if (matches ("hasCockosExtensions"))
            return 0xbeef0000;
        if (matches ("hasCockosEmbeddedUI"))
            return 0xbeef0000;      
        return 0;

    }

