#pragma once

#include <iostream>
#include <juce_audio_processors/juce_audio_processors.h>

#include <pluginterfaces/base/ftypes.h>
#include <pluginterfaces/base/ftypes.h>
#include <pluginterfaces/base/funknown.h>
#include <pluginterfaces/vst/ivsthostapplication.h>

/*==============================================================================
  Reaper speciffic definitions
*/  
namespace reaper
{
    using namespace Steinberg;
    using INT_PTR = juce::pointer_sized_int;
    using uint32 = Steinberg::uint32;

    #include "extern/reaper_plugin_fx_embed.h"
    #include "extern/reaper_vst3_interfaces.h"
}


//==============================================================================
struct EmbeddedViewListener
{
    virtual ~EmbeddedViewListener() = default;
    virtual Steinberg::TPtrInt handledEmbeddedUIMessage (int msg,
                                                         Steinberg::TPtrInt parm2,
                                                         Steinberg::TPtrInt parm3) = 0;
};

//==============================================================================
class EmbeddedUI : public reaper::IReaperUIEmbedInterface {
public:
    explicit EmbeddedUI (EmbeddedViewListener& demo) : listener (demo) {}

    Steinberg::TPtrInt embed_message (int msg,
                                      Steinberg::TPtrInt parm2,
                                      Steinberg::TPtrInt parm3) override
    {
        return listener.handledEmbeddedUIMessage (msg, parm2, parm3);
    }

    Steinberg::uint32 PLUGIN_API addRef() override   { return (Steinberg::uint32) ++refCount; }
    Steinberg::uint32 PLUGIN_API release() override  { return (Steinberg::uint32) --refCount; }

    Steinberg::tresult PLUGIN_API queryInterface (const Steinberg::TUID tuid, void** obj) override
    {
        if (std::memcmp (tuid, iid, sizeof (Steinberg::TUID)) == 0)
        {
            *obj = this;
            return Steinberg::kResultOk;
        }

        *obj = nullptr;
        return Steinberg::kNoInterface;
    }

private:
    EmbeddedViewListener& listener;
    std::atomic<int> refCount { 1 };
};


enum ChangeOrigin {co_default=0, co_main, co_embed, co_dawparam, co_midi, co_file};

struct CurrentParameter {double midiVolume; ChangeOrigin changeOrigin;};

struct MidiValue {uint8_t val;};

struct MidiFiFo
{
    void addToFifo (MidiValue* someData, int numItems)
    {
        int start1, size1, start2, size2;
        abstractFifo.prepareToWrite (numItems, start1, size1, start2, size2);
        if (size1 > 0) copyMidiData (myBuffer + start1, someData, size1);
        if (size2 > 0) copyMidiData (myBuffer + start2, someData + size1, size2);
        abstractFifo.finishedWrite (size1 + size2);
    }
 
    int readFromFifo (MidiValue* someData, int numItems)
    {
        int start1, size1, start2, size2, size;
        abstractFifo.prepareToRead (numItems, start1, size1, start2, size2);
        size = size1+size2;
        if ((size) > 0) {
          if (size1 > 0) copyMidiData (someData, myBuffer + start1, size1);
          if (size2 > 0) copyMidiData (someData + size1, myBuffer + start2, size2);          
          abstractFifo.finishedRead (size);
        } 
        return size;
    }
 
    juce::AbstractFifo abstractFifo { 1024 };
    MidiValue myBuffer[1024];
    void copyMidiData(MidiValue *_to, MidiValue *_from, int size) {
      memcpy(_to, _from, size*sizeof(MidiValue));
    };
} ;



/* copied from demo
class ReaperEmbeddedViewDemo  : public AudioProcessor,
                                public VSTCallbackHandler,
                                public VST3ClientExtensions,
                                private EmbeddedViewListener,
                                private Timer

*/                                


//==============================================================================
class AudioPluginAudioProcessor : public juce::AudioProcessor, juce::Timer, 
                                         juce::AudioProcessorListener,
                                         juce::AsyncUpdater,
                                  public juce::VSTCallbackHandler,
                                  public juce::VST3ClientExtensions,
                                  private EmbeddedViewListener
{
public:
    //==============================================================================
    AudioPluginAudioProcessor();
    ~AudioPluginAudioProcessor() override;

    //==============================================================================
    void prepareToPlay(double sampleRate, int samplesPerBlock) override;
    void releaseResources() override;

    bool isBusesLayoutSupported(const BusesLayout& layouts) const override;

    void processBlock(juce::AudioBuffer<float>&, juce::MidiBuffer&) override;
    using AudioProcessor::processBlock;

    //==============================================================================
    juce::AudioProcessorEditor* createEditor() override;
    bool hasEditor() const override;

    //==============================================================================
    const juce::String getName() const override;

    bool acceptsMidi() const override;
    bool producesMidi() const override;
    bool isMidiEffect() const override;
    double getTailLengthSeconds() const override;

    //==============================================================================
    int getNumPrograms() override;
    int getCurrentProgram() override;
    void setCurrentProgram(int index) override;
    const juce::String getProgramName(int index) override;
    void changeProgramName(int index, const juce::String& newName) override;

    //==============================================================================
    void getStateInformation(juce::MemoryBlock& destData) override;
    void setStateInformation(const void* data, int sizeInBytes) override;

    //==============================================================================
    void timerCallback() override;

    //==============================================================================
    void audioProcessorParameterChanged(juce::AudioProcessor* processor,
                                                 int parameterIndex,
                                                 float newValue) override;
    void audioProcessorChanged (juce::AudioProcessor* processor, const juce::AudioProcessorListener::ChangeDetails& details) override;

    void handleAsyncUpdate() override;


    //==============================================================================

    bool getEmbedEditor();
    void setEmbeddedUpdated(bool v);
    juce::Slider *getMidiVolume_embed();
    void setMidiVolume_embed(juce::Slider *v);  
    juce::Slider *getMidiVolume_main();
    void setMidiVolume_main(juce::Slider *v);  
    juce::AudioParameterFloat* getParamMidiVolume();
    CurrentParameter *getCurrentParameter();
    void dawNotify();
    void *getfuncaddr_(const char* funcname) {
       if (!hostcb) return NULL;
       return (void*)hostcb(/*NULL,*/ 0xdeadbeef, 0xdeadf00d, 0, (void*)funcname, 0.0);        
    }

private:
    juce::pointer_sized_int reaperHandleEmbedGUI(void* value, void* ptr, int opt);
    juce::AudioProcessorEditor* reaperCreateEmbedEditor();                                // create reduced editor GUI for embedding 


    //==============================================================================
    juce::AudioProcessorEditor* embedComponent;
    void endEembedEditor();
    bool embedded_updated = true;
    bool embedEditor = false;
    bool canEndEmbedEditor = true;
    int  juceStartDelay = 100;  // ca. 5.5 secs
    int  infContetext = 0;
    int  dawLastChange = -1;
    int8_t midiLastChange  = -1;

    CurrentParameter currentParameter = {0, co_default};
    juce::Slider *midiVolume_embed = NULL;                                              // for more copmplex GUI parhaps better use a strct of components
    juce::Slider *midiVolume_main  = NULL;                                              // for more copmplex GUI parhaps better use a strct of components


    //==============================================================================
    juce::AudioParameterFloat *midiVolumeParameter;

    MidiFiFo midiInFiFo;
    MidiFiFo midiOutFiFo;

    //==============================================================================
    juce::pointer_sized_int handleVstManufacturerSpecific(juce::int32 index, juce::pointer_sized_int value,	void* ptr, float opt) override;

    juce::pointer_sized_int handleVstPluginCanDo (juce::int32 index,
                                                      juce::pointer_sized_int value,
                                                      void* ptr,
                                                      float opt) override;
    void handleVstHostCallbackAvailable (std::function<VstHostCallbackType>&& callback) override;
    
    Steinberg::TPtrInt handledEmbeddedUIMessage (int msg,
                                                 Steinberg::TPtrInt parm2,
                                                 Steinberg::TPtrInt parm3) override;
    void setIHostApplication (Steinberg::FUnknown* ptr) override;
    int32_t queryIEditController (const Steinberg::TUID tuid, void** obj) override;
    EmbeddedUI embeddedUi { *this };
    std::function<VstHostCallbackType>&& hostcb = NULL;

    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR(AudioPluginAudioProcessor)
 };