Demonstrating DAW specific VST extensions with a JUCE based plugin. 

===========================================================================================================================================================================

We want to acknowledge that we bugged a lot of people in the process of figuring this out.
Credit, and sincerest thanks to:
	GavinRay97 
		Starting the project of using Reaper's "FX GUI embedding" feature with JUCE based VST3 plugins, on which this demonstration project is based
		Providing the happily rather small but very clever Patch that allows initial testing all this with JUCE version 6.0.8
	Gertius 
		The original code for rendering JUCE components to LICE bitmaps
    Robbert van der Helm
        Bunch of random questions, tip about FUnknownPtr<T> for casting between VST3 interfaces
    Xenakios
        Tips on REAPER specific stuff he had learned
    baconpaul from the Surge synth team
        Many C++ and VST3 questions
    Reuk
        A lot (most of?) the feedback and questions, came up with the architecture, including when finally porting our source code from the initial patched JUCE version 6.0.8 to the developers preview of the upcoming official JUCE enhancement.
    Ben Vining
        Misc feedback, code for the static/thread-local singleton audio processor pointer
    Schwa from Cockos
        Helping Gavin debug & telling him what REAPER was seeing
        Sharing the section of REAPER code that does the queryInterface() for IReaperUIEmbed and then calls the embed_message()
        Patching the VST3 interface to fix a small issue then releasing, a day after reporting a bug
    nofish
        Who always is helpful

===========================================================================================================================================================================

Warning:
Currently  (July 2021) neither Reaper nor JUCE completely supports the use of this project "out of the box".
Reaper 6.28 does not provide the "embedding" interface for VST3, while Reaper 6.29 does). 
Moreover Reaper seems to feature a bug that prevents the VST3 plugin from deleting Midi messages from the Midi stream in certain situations.
Currently the support for vendor specific VST3 enhancements is only available in a "developer" version of the JUCE library.

===========================================================================================================================================================================

This project is just an example on how to do a VST2 or VST3 plugin that uses Vendor specific extensions to the VST API. 
Here, two vendor specific extensions defined by Reaper by Cockos are demonstrated:
 1) Attaching to the internal API in Reaper to allow a VST work like a dedicated Reaper extension and gain complete control over most aspects of the DAW
 2) embedding a secondary (small) version of the VST's GUI in the Mixer Control Panel or the Track Control Panel of the track in which the plugin is loaded. 
 
The code of this example compiles (using CMake) and runs as well as a VST2 as a VST3, depending on the appropriate CMAKE option. 


The plugin demonstrates how a parameter value can be updated and displayed from various sources and to various targets: 
  - The DAW project file (reading, when loading the plugin, starting the project, etc). Writing, when saving the project)
  - "Show in Track Controls", "UI", Automation, Envelope, i.e. "DAW Parameters" as well reading as writing
  - The main GUI of the plugin (if displayed)
  - The "embedded" GUI in the "Track Control Panel" or the "Mixer Control Panel" (if enabled)
  - Midi in the stream within the track (reading messages CC #1, channel 1). Writing CC messages into the Midi stream. 
  - Sending "Console Output" messages to Reaper to be displayed in a log window.
  
The embedded GUI shows the source of the last setting of the parameter: 
  - from the project file 
  - from the main GUI
  - from the embedded GUI
  - from DAW Parameter change
  - from Midi
  
Intentionally, the same function "AudioPluginAudioProcessorEditor()" is used to create both the embedded and the standard GUI for the plugin. 
The function "processorRef.getEmbedEditor()" decides if the "Editor" code is called for the embedded or the main GUI. By this it's easy to share functionality between the two, if appropriate. As shown, the same Widgets can be used, as they automatically are managed as appropriate by the JUCE framework.
Mind that the "Editor" is called only once when loading the plugin for the embedded GUI, which then is kept inactive, unless the mouse is moved onto the frame Reaper provides for the embedded GUI. The main GUI is created every time Reaper shows the Plugin and is destroyed when the plugin window is closed. 

